//
//  FJDIndexedItemsWindowController.m
//  FJDIndexedItemsWindow
//
//  Created by FUJIDANA on 06/08/22.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJDIndexedItemsWindowController.h"
#import "FJDIndexedItemsArrayController.h"

NSString *FJDIndexedItemsToolbarReindexSelectionIdentifier = @"FJDIndexedItemsToolbarReindexSelectionIdentifier";


@implementation FJDIndexedItemsWindowController


#pragma mark Initialization

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	// Fetch a FJDIndexManager instance and set it to itemsController's indexManager.
	
	NSString				*entityName		= [self indexManagerEntityName];
	NSManagedObjectContext	*context		= [self managedObjectContext];
	NSFetchRequest			*fetchRequest	= [[[NSFetchRequest alloc] init] autorelease];
	NSEntityDescription		*entity			= [NSEntityDescription entityForName:entityName inManagedObjectContext:context];
	NSManagedObject			*indexManager;
	[fetchRequest setEntity:entity];
	
	NSError *fetchError;
	NSArray *fetchResults = [context executeFetchRequest:fetchRequest error:&fetchError];
	if (fetchResults == nil) {
		[NSApp presentError:fetchError];
		[NSApp terminate:nil];
	} else if ([fetchResults count] > 0) {
		
		// If indexManager is found in managed object context, retain it.
		indexManager = [fetchResults lastObject];
		
	} else {
		
		// If indexManager is not found in managed object context, instantiate and retain it.
		[context processPendingChanges];
		[[context undoManager] disableUndoRegistration];
		
		indexManager = [NSEntityDescription insertNewObjectForEntityForName:entityName inManagedObjectContext:context];
		
		[context processPendingChanges];
		[[context undoManager] enableUndoRegistration];
	}
	
	[itemsController setValue:indexManager forKey:@"indexManager"];
}

#pragma mark For subclass to override

- (NSString *)indexManagerEntityName
{
	return @"IndexManager";
}

#pragma mark Action methods

- (IBAction)reindexSelection:(id)sender
{
	NSArray			*selectedItems	= [itemsController selectedObjects];
	NSEnumerator	*enumerator		= [selectedItems objectEnumerator];
	NSManagedObject	*item;
	
	NSMutableSet *exceptedItemSet = [NSMutableSet setWithArray:selectedItems];
	
//	SInt32 firstIndex = [[[selectedItems objectAtIndex:0] valueForKey:@"index"] longValue];
	while (item = [enumerator nextObject]) {
		int unusedIndex = [(FJDIndexedItemsArrayController *)itemsController unusedIndexExceptItems:exceptedItemSet];
		if (unusedIndex != NSNotFound) {
			[item setValue:[NSNumber numberWithInt:unusedIndex] forKey:@"index"];
		}
		[exceptedItemSet removeObject:item];
	}
	
//	[[[self managedObjectContext] undoManager] setActionName:NSLocalizedStringFromTable(@"Reindex", @"CoreDataLocalizable", @"undo.reindex")];
}

#pragma mark Methods delegated by NSToolbar

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem;
	if ([itemIdentifier isEqual:FJDIndexedItemsToolbarReindexSelectionIdentifier]) {
		
		// --- Reindex Selection ---
		
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		
		NSString *label = NSLocalizedStringFromTable(@"Reindex", @"CoreDataLocalizable", @"toolbarItem.reindexSelection.label");
		NSString *paletteLabel = NSLocalizedStringFromTable(@"Reindex Selection", @"CoreDataLocalizable", @"toolbarItem.reindexSelection.paletteLabel");
		NSString *toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Reindex Number of Selected %@.", @"CoreDataLocalizable", @"toolbarItem.reindexSelection.toolTip"), [[self localizedPluralItemName] capitalizedString]];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(reindexSelection:)];
		
	} else {
		toolbarItem = [super toolbar:toolbar itemForItemIdentifier:itemIdentifier willBeInsertedIntoToolbar:flag];
	}
	return toolbarItem;
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	NSArray *toolbarItemIdentifiers = [super toolbarAllowedItemIdentifiers:toolbar];
	if (toolbarItemIdentifiers) {
		return [toolbarItemIdentifiers arrayByAddingObject:FJDIndexedItemsToolbarReindexSelectionIdentifier];
	} else {
		return [NSArray arrayWithObject:FJDIndexedItemsToolbarReindexSelectionIdentifier];
	}
}

#pragma mark Informal protocol of NSToolbarItemValidation

- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem
{
	if ([theItem action] == @selector(reindexSelection:)) {
		return [[itemsController selectedObjects] count] >= 2;
	} else if ([FJDItemsInFolderWindowController instancesRespondToSelector:@selector(validateToolbarItem:)]) {
		return [super validateToolbarItem:theItem];
	}
	return YES;
}

#pragma mark Informal protocol of NSMenuValidation

- (BOOL)validateMenuItem:(id <NSMenuItem>)theItem
{
	if ([theItem action] == @selector(reindexSelection:)) {
		return [[itemsController selectedObjects] count] >= 2;
	} else if ([FJDItemsInFolderWindowController instancesRespondToSelector:@selector(validateMenuItem:)]) {
		return [super validateMenuItem:theItem];
	}
	return YES;
}

@end
